/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger.dangerous;

import com.wardanger.dangerous.CreeperBehaviorManager;
import com.wardanger.dangerous.DangerousConfig;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GearManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    private static final String EQUIPMENT_MODIFIED_TAG = "dangerous_equipment_modified";
    private static final int SURFACE_Y_THRESHOLD = 64;
    private static final int CAVE_Y_THRESHOLD = 0;

    public static void equipMobBasedOnDifficulty(Mob mob, ServerLevel world) {
        Difficulty difficulty = world.m_46791_();
        CompoundTag entityData = mob.getPersistentData();
        if (entityData.m_128471_(EQUIPMENT_MODIFIED_TAG)) {
            return;
        }
        if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:zombie")) || mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:skeleton"))) {
            if (mob.m_20186_() >= 64.0) {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.surfaceArmor.get(), (List)DangerousConfig.CONFIG.surfaceWeapons.get(), (List)DangerousConfig.CONFIG.surfaceArmorSets.get());
            } else if (mob.m_20186_() >= 0.0) {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.caveArmor.get(), (List)DangerousConfig.CONFIG.caveWeapons.get(), (List)DangerousConfig.CONFIG.caveArmorSets.get());
            } else {
                GearManager.giveLevelGear(mob, difficulty, (List)DangerousConfig.CONFIG.deepCaveArmor.get(), (List)DangerousConfig.CONFIG.deepCaveWeapons.get(), (List)DangerousConfig.CONFIG.deepCaveArmorSets.get());
            }
        }
        if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:zombie"))) {
            GearManager.giveZombieWeapon(mob);
        } else if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:pillager"))) {
            GearManager.giveCrossbowToPillager(mob);
            if (GearManager.isPillagerCaptain(mob)) {
                GearManager.giveBannerToCaptain(mob);
            }
        } else if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:skeleton"))) {
            GearManager.giveSkeletonWeapon(mob);
        } else if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:creeper"))) {
            CreeperBehaviorManager.increaseCreeperSpeed((Creeper)mob);
        } else if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:zombified_piglin"))) {
            GearManager.equipGoldArmorPiecesIfChance(mob, difficulty, world);
            GearManager.maybeGiveZombifiedPiglinWeapon(mob, world);
        } else if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:piglin"))) {
            GearManager.equipGoldArmorPiecesIfChance(mob, difficulty, world);
        } else if (mob.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:piglin_brute"))) {
            GearManager.equipGoldArmorPiecesIfChance(mob, difficulty, world);
            GearManager.givePiglinBruteWeapon(mob, world);
        }
        entityData.m_128379_(EQUIPMENT_MODIFIED_TAG, true);
    }

    private static void equipGoldArmorPiecesIfChance(Mob mob, Difficulty difficulty, ServerLevel world) {
        double chance = GearManager.getGearChanceForDifficulty(difficulty);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42476_), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42477_), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42478_), chance, world);
        GearManager.equipFixedArmorIfChance(mob, EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42479_), chance, world);
    }

    private static void equipFixedArmorIfChance(Mob mob, EquipmentSlot slot, ItemStack stack, double chance, ServerLevel world) {
        if (stack.m_41619_()) {
            return;
        }
        if (!mob.m_6844_(slot).m_41619_()) {
            return;
        }
        if (RANDOM.nextDouble() >= chance) {
            return;
        }
        GearManager.maybeEnchantItem(stack, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get());
        GearManager.giveNBT(stack);
        mob.m_8061_(slot, stack);
    }

    private static void maybeGiveZombifiedPiglinWeapon(Mob mob, ServerLevel world) {
        ItemStack main = mob.m_21205_();
        if (!main.m_41619_()) {
            return;
        }
        double chance = (Double)DangerousConfig.CONFIG.weaponChance.get();
        if (RANDOM.nextDouble() >= chance) {
            return;
        }
        ItemStack w = RANDOM.nextBoolean() ? new ItemStack((ItemLike)Items.f_42430_) : new ItemStack((ItemLike)Items.f_42433_);
        GearManager.maybeEnchantItem(w, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get());
        GearManager.giveNBT(w);
        mob.m_8061_(EquipmentSlot.MAINHAND, w);
    }

    private static void givePiglinBruteWeapon(Mob mob, ServerLevel world) {
        ItemStack w = RANDOM.nextDouble() < 0.05 ? new ItemStack((ItemLike)Items.f_42396_) : (RANDOM.nextDouble() < 0.15 ? new ItemStack((ItemLike)Items.f_42391_) : new ItemStack((ItemLike)Items.f_42433_));
        GearManager.maybeEnchantItem(w, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get());
        GearManager.giveNBT(w);
        mob.m_8061_(EquipmentSlot.MAINHAND, w);
    }

    private static void giveCrossbowToPillager(Mob mob) {
        ItemStack crossbow = new ItemStack((ItemLike)Items.f_42717_);
        mob.m_8061_(EquipmentSlot.MAINHAND, crossbow);
    }

    private static void giveBannerToCaptain(Mob mob) {
        ItemStack ominousBanner = new ItemStack((ItemLike)Items.f_42660_);
        mob.m_8061_(EquipmentSlot.OFFHAND, ominousBanner);
    }

    private static boolean isPillagerCaptain(Mob mob) {
        CompoundTag tag = mob.getPersistentData();
        return tag.m_128471_("IsCaptain");
    }

    private static void giveLevelGear(Mob mob, Difficulty difficulty, List<String> armorList, List<String> weaponList, List<?> armorSetList) {
        if (GearManager.tryEquipArmorSet(mob, armorSetList)) {
            return;
        }
        double chance = GearManager.getGearChanceForDifficulty(difficulty);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.HEAD, "helmet", chance, armorList);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.CHEST, "chestplate", chance, armorList);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.LEGS, "leggings", chance, armorList);
        GearManager.equipArmorIfChance(mob, EquipmentSlot.FEET, "boots", chance, armorList);
    }

    private static double getGearChanceForDifficulty(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> (Double)DangerousConfig.CONFIG.easyGearChance.get();
            case Difficulty.NORMAL -> (Double)DangerousConfig.CONFIG.normalGearChance.get();
            case Difficulty.HARD -> (Double)DangerousConfig.CONFIG.hardGearChance.get();
            default -> 0.0;
        };
    }

    private static void equipArmorIfChance(Mob mob, EquipmentSlot slot, String armorType, double chance, List<String> availableArmor) {
        List<String> filteredArmor = availableArmor.stream().filter(armor -> armor.contains(armorType)).toList();
        if (!filteredArmor.isEmpty() && RANDOM.nextDouble() < chance) {
            String selectedArmor = filteredArmor.get(RANDOM.nextInt(filteredArmor.size()));
            ItemStack armor2 = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(selectedArmor))));
            GearManager.maybeEnchantItem(armor2, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get());
            GearManager.giveNBT(armor2);
            mob.m_8061_(slot, armor2);
        }
    }

    private static void giveSkeletonWeapon(Mob mob) {
        ItemStack bow = new ItemStack((ItemLike)Items.f_42411_);
        GearManager.maybeEnchantItem(bow, (List)DangerousConfig.CONFIG.availableBowEnchantments.get());
        mob.m_8061_(EquipmentSlot.MAINHAND, bow);
        if (RANDOM.nextDouble() < (Double)DangerousConfig.CONFIG.weaponChance.get()) {
            ItemStack meleeWeapon = GearManager.getRandomMeleeWeapon();
            GearManager.maybeEnchantItem(meleeWeapon, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get());
            mob.m_8061_(EquipmentSlot.OFFHAND, meleeWeapon);
        }
    }

    private static ItemStack getRandomMeleeWeapon() {
        List availableWeapons = (List)DangerousConfig.CONFIG.surfaceWeapons.get();
        String selectedWeapon = (String)availableWeapons.get(RANDOM.nextInt(availableWeapons.size()));
        return new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(selectedWeapon))));
    }

    private static void giveZombieWeapon(Mob mob) {
        if (RANDOM.nextDouble() < (Double)DangerousConfig.CONFIG.weaponChance.get()) {
            ItemStack weapon = GearManager.getRandomMeleeWeapon();
            GearManager.maybeEnchantItem(weapon, (List)DangerousConfig.CONFIG.availableWeaponEnchantments.get());
            mob.m_21008_(mob.m_7655_(), weapon);
        }
    }

    private static void maybeEnchantItem(ItemStack item, List<String> availableEnchantments) {
        double enchantmentChance = RANDOM.nextDouble();
        if (enchantmentChance < (Double)DangerousConfig.CONFIG.enchantmentChance.get()) {
            String selectedEnchantment = availableEnchantments.get(RANDOM.nextInt(availableEnchantments.size()));
            if (!selectedEnchantment.contains(":")) {
                LOGGER.warn("Invalid enchantment format in the config: {}. Correct format: modid:enchantment_name", (Object)selectedEnchantment);
                return;
            }
            ResourceLocation enchantmentId = new ResourceLocation(selectedEnchantment);
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(enchantmentId)) {
                LOGGER.warn("Enchantment not found in the registry: {}", (Object)selectedEnchantment);
                return;
            }
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantmentId);
            if (enchantment == null) {
                return;
            }
            item.m_41663_(enchantment, 1 + RANDOM.nextInt(3));
        }
    }

    private static void giveNBT(ItemStack item) {
        CompoundTag tag = item.m_41784_();
        tag.m_128379_("dangerous_mod_item", true);
        item.m_41751_(tag);
    }

    private static ItemStack getItemByName(String itemName) {
        if (!itemName.contains(":")) {
            LOGGER.warn("Invalid item format in the config: {}. Correct format: modid:item_name", (Object)itemName);
            return ItemStack.f_41583_;
        }
        ResourceLocation itemId = new ResourceLocation(itemName);
        if (!ForgeRegistries.ITEMS.containsKey(itemId)) {
            LOGGER.warn("Item not found in the registry: {}", (Object)itemName);
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(itemId)));
    }

    private static boolean tryEquipArmorSet(Mob mob, List<?> armorSetList) {
        if (armorSetList == null || armorSetList.isEmpty()) {
            return false;
        }
        for (Object raw : armorSetList) {
            ArmorSet set;
            block7: {
                try {
                    if (raw instanceof String) {
                        String s = (String)raw;
                        set = GearManager.parseArmorSetString(s);
                        break block7;
                    }
                    if (raw instanceof List) {
                        List lst = (List)raw;
                        set = GearManager.parseArmorSetList(lst);
                        break block7;
                    }
                    LOGGER.warn("Unknown armor set entry type: {}", raw);
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to parse armor set entry: {}", raw, (Object)t);
                }
                continue;
            }
            if (set == null || RANDOM.nextDouble() >= set.chance) continue;
            ItemStack head = GearManager.getItemByName(set.head.toString());
            ItemStack chest = GearManager.getItemByName(set.chest.toString());
            ItemStack legs = GearManager.getItemByName(set.legs.toString());
            ItemStack boots = GearManager.getItemByName(set.boots.toString());
            if (head.m_41619_() || chest.m_41619_() || legs.m_41619_() || boots.m_41619_()) {
                LOGGER.warn("Armor set skipped due to missing item: {}", raw);
                continue;
            }
            GearManager.maybeEnchantItem(head, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get());
            GearManager.maybeEnchantItem(chest, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get());
            GearManager.maybeEnchantItem(legs, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get());
            GearManager.maybeEnchantItem(boots, (List)DangerousConfig.CONFIG.availableArmorEnchantments.get());
            GearManager.giveNBT(head);
            GearManager.giveNBT(chest);
            GearManager.giveNBT(legs);
            GearManager.giveNBT(boots);
            mob.m_8061_(EquipmentSlot.HEAD, head);
            mob.m_8061_(EquipmentSlot.CHEST, chest);
            mob.m_8061_(EquipmentSlot.LEGS, legs);
            mob.m_8061_(EquipmentSlot.FEET, boots);
            return true;
        }
        return false;
    }

    private static ArmorSet parseArmorSetString(String raw) {
        String[] parts;
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        if (s.startsWith("[")) {
            s = s.substring(1);
        }
        if (s.endsWith("]")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((parts = s.split(",")).length != 5) {
            LOGGER.warn("Invalid armor set format (need 5 entries): {}", (Object)raw);
            return null;
        }
        String h = parts[0].trim();
        String c = parts[1].trim();
        String l = parts[2].trim();
        String b = parts[3].trim();
        String p = parts[4].trim();
        ResourceLocation rh = GearManager.tryRL(h);
        ResourceLocation rc = GearManager.tryRL(c);
        ResourceLocation rl = GearManager.tryRL(l);
        ResourceLocation rb = GearManager.tryRL(b);
        if (rh == null || rc == null || rl == null || rb == null) {
            LOGGER.warn("Invalid item id in armor set: {}", (Object)raw);
            return null;
        }
        Double pct = GearManager.tryParseDouble(p);
        if (pct == null) {
            LOGGER.warn("Invalid percentage in armor set: {}", (Object)raw);
            return null;
        }
        double chance = GearManager.clamp01(GearManager.percentToUnit(pct));
        return new ArmorSet(rh, rc, rl, rb, chance);
    }

    private static ArmorSet parseArmorSetList(List<?> lst) {
        double pct;
        String l;
        String c;
        String h;
        Object op;
        Object ob;
        block11: {
            block10: {
                if (lst.size() != 5) {
                    LOGGER.warn("Invalid armor set list size (need 5): {}", lst);
                    return null;
                }
                Object oh = lst.get(0);
                Object oc = lst.get(1);
                Object ol = lst.get(2);
                ob = lst.get(3);
                op = lst.get(4);
                if (!(oh instanceof String)) break block10;
                h = (String)oh;
                if (!(oc instanceof String)) break block10;
                c = (String)oc;
                if (!(ol instanceof String)) break block10;
                l = (String)ol;
                if (ob instanceof String) break block11;
            }
            LOGGER.warn("Armor set list expects 4 strings + 1 number: {}", lst);
            return null;
        }
        String b = (String)ob;
        ResourceLocation rh = GearManager.tryRL(h);
        ResourceLocation rc = GearManager.tryRL(c);
        ResourceLocation rl = GearManager.tryRL(l);
        ResourceLocation rb = GearManager.tryRL(b);
        if (rh == null || rc == null || rl == null || rb == null) {
            LOGGER.warn("Invalid item id in armor set list: {}", lst);
            return null;
        }
        if (op instanceof Number) {
            Number n = (Number)op;
            pct = n.doubleValue();
        } else if (op instanceof String) {
            String sp = (String)op;
            Double v = GearManager.tryParseDouble(sp);
            if (v == null) {
                return null;
            }
            pct = v;
        } else {
            LOGGER.warn("Armor set percentage must be number or numeric string: {}", lst);
            return null;
        }
        double chance = GearManager.clamp01(GearManager.percentToUnit(pct));
        return new ArmorSet(rh, rc, rl, rb, chance);
    }

    private static ResourceLocation tryRL(String s) {
        try {
            return new ResourceLocation(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Double tryParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static double percentToUnit(double pct) {
        if (pct < 0.0) {
            pct = 0.0;
        }
        return GearManager.clamp01(pct / 100.0);
    }

    private static double clamp01(double x) {
        return Math.max(0.0, Math.min(1.0, x));
    }

    private static final class ArmorSet {
        final ResourceLocation head;
        final ResourceLocation chest;
        final ResourceLocation legs;
        final ResourceLocation boots;
        final double chance;

        ArmorSet(ResourceLocation h, ResourceLocation c, ResourceLocation l, ResourceLocation b, double p) {
            this.head = h;
            this.chest = c;
            this.legs = l;
            this.boots = b;
            this.chance = p;
        }
    }
}

